<?php
/*** Component - Image With Text ***/

// Block preview
if( !empty( $block['data']['_is_preview'] ) ) { ?>
    <figure class="is_preview" style="width:100%; height:300px; display: block;">
        <img aria-label="Table" style="width:100%;height:100%;display: block;object-position: center;object-fit: contain;" src="<?php echo site_url(); ?>/wp-content/uploads/2023/12/Screenshot-from-2023-12-22-13-09-29.png" alt="Table">
    </figure>
<?php } 
// Create id attribute allowing for custom "anchor" value.
$id = $block['id'];
if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
}

// Create class attribute allowing for custom "className" and "align" values.
$className = '';
if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
}
if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
}

?>
<?php
// Get the value of the radio button field
$radio_value = get_field('select_layout');

// Output content based on the selected value
if ($radio_value) {
    if ($radio_value === 'Image Left Content Right') {

        $image = get_field('image');
        $logo = get_field('logo');
        $title = get_field('title');
        $content = get_field('content');
        $button = get_field('button');
        $alt_text = $image['alt']; 
        $alt_logo = $logo['alt']; 
        if ($title || $content || $button || $image) :
?>
    <div id="<?php echo esc_attr($id); ?>" class="content-right-image-left image-with-content common-pd bg<?php echo esc_attr($className); ?>"> 
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="image-border">
                        <?php echo wp_get_attachment_image($image['ID'], 'full', false, array('alt' => esc_attr($alt_text))); ?>
                    </div>
                     <?php if ($logo) : ?>
                     <div class="logo-image">
                        <?php echo wp_get_attachment_image($logo['ID'], 'full', false, array('alt' => esc_attr($alt_logo))); ?>
                    </div>
                <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="text-side">
                    <h2 class="heading"><?php echo $title; ?></h2>
                    <p><?php echo $content; ?></p>
                    <?php if ($button) :
                        $link_url = $button['url'];
                        $link_text = $button['title'];
                        $link_target = !empty($button['target']) ? $button['target'] : '_self';
                    ?>
                        <a class="btn" href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_text); ?></a>
                    <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php
    } elseif ($radio_value === 'Content Left Image Right') {

        $image = get_field('image');
        $logo = get_field('logo');
        $title = get_field('title');
        $content = get_field('content');
        $button = get_field('button');
        $alt_text = $image['alt']; 
        $alt_logo = $logo['alt']; 
        if ($title || $content || $button || $image) :
?>
    <div id="<?php echo esc_attr($id); ?>" class="content-left-image-right image-with-content common-pd bg<?php echo esc_attr($className); ?>"> 
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="text-side">
                    <h2 class="heading"><?php echo $title; ?></h2>
                    <p><?php echo $content; ?></p>
                    <?php if ($button) :
                        $link_url = $button['url'];
                        $link_text = $button['title'];
                    ?>
                        <a class="btn btn-width" href="<?php echo esc_url($link_url); ?>"><?php echo esc_html($link_text); ?></a>
                    <?php endif; ?>
                </div>
                </div>
                <div class="col-md-6">
                    <div class="image-border">
                        <?php echo wp_get_attachment_image($image['ID'], 'full', false, array('alt' => esc_attr($alt_text))); ?>
                    </div>
                    <?php if ($logo) : ?>
                    <div class="logo-image">
                        <?php echo wp_get_attachment_image($logo['ID'], 'full', false, array('alt' => esc_attr($alt_text))); ?>
                    </div>
                <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php
    }
}
?>